<div class="block block-rounded">
    <div class="block-content block-content-full bg-gd-fruit text-center">
        <a class="item item-circle mx-auto bg-black-25" href="javascript:void(0)">
            <i class="fab fa-2x fa-android text-white"></i>
        </a>
        <p class="text-white font-size-h3 font-w300 mt-3 mb-0">
           <?php echo e(__('dcm.most_viewed_apps_title')); ?>

        </p>
    </div>
    <div class="block-content block-content-full">

        <table class="table table-borderless table-striped table-hover">
            <tbody>

                <?php if(isset( $sidebar['most_viewed_apps'])): ?>

                    <?php $__currentLoopData = $sidebar['most_viewed_apps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php
                            switch ($index) {
                                case 0:
                                    $ribbonColor = 'danger';
                                    break;
                                case 1:
                                    $ribbonColor = 'warning';
                                    break;
                                case 2:
                                    $ribbonColor = 'info';
                                    break;
                                default:
                                    $ribbonColor = 'light';
                                    break;
                            }
                        ?>
                        <tr>
                            <td style="width: 40px;">
                                <span class="ribbon ribbon-left ribbon-bookmark ribbon-<?php echo e($ribbonColor); ?>">
                                    <span class="ribbon-box">
                                        <?php echo e($app->views_count); ?>

                                    </span>
                                </span>
                            </td>
                            <td >
                                <img title="<?php echo e($app->title); ?>" alt="<?php echo e($app->title); ?>" src="<?php echo e($app->app_image_url); ?>" width="30px">
                            </td>
                            <td>
                             <a title="<?php echo e($app->title); ?>" href="<?php echo e($app->app_detail_url); ?>" style="color: #4b4e52;">
                                <strong> <?php echo e(str_limit($app->title, 32)); ?></strong>
                                <div class="stars mb-0" style="margin-left: 0;">
                                    <span class="score" title="<?php echo e(__('dcm.app_average_rating',['attr' => $app->title, 'rating' => $app->current_ratings ])); ?>" style="width: <?php echo e(ceil(((double) $app->current_ratings  / 5) * 100)); ?>%;"></span>
                                </div>
                                    </a>
                            </td>
                            <td class="text-center">
                                <a  title="<?php echo e($app->title); ?>" href="<?php echo e($app->app_detail_url); ?>" class="btn btn-outline-success btn-sm">
                                    <i class="fa fa-fw fa-download mr-1"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php else: ?>
                    <tr class="text-center">
                        <td> <?php echo e(__('dcm.no_apps_configured')); ?></td>
                    </tr>
                <?php endif; ?>


            </tbody>
        </table>
        
    </div>
</div>